﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using System.Collections;
using System.Collections.Generic;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;

using GE.Visualisation;
using GE.Tools;

namespace GE.Manager
{
    /// <summary>
    /// Enumerates font types.
    /// </summary>
    enum FontType
    {
        Default,
        MenuTitle,
        MenuButton
        //HudTimer
    }

    /// <summary>
    /// Manages fonts.
    /// </summary>
    class FontManager
    {
        /// <summary>
        /// Unique instance of the FontManager class.
        /// </summary>
        private static FontManager m_instance = new FontManager();

        /// <summary>
        /// Content manager.
        /// </summary>
        private ContentManager m_content;

        /// <summary>
        /// Links font types to fonts.
        /// </summary>
        private Dictionary<FontType, SpriteFont> m_fonts;

        /// <summary>
        /// Unique instance of the FontManager class.
        /// </summary>
        public static FontManager Instance
        {
            get { return m_instance; }
        }

        /// <summary>
        /// Private constructor.
        /// </summary>
        private FontManager()
        {
            m_fonts = new Dictionary<FontType, SpriteFont>();
        }

        /// <summary>
        /// Initializes the font manager.
        /// </summary>
        /// <param name="content">content manager</param>
        public void init(ContentManager content)
        {
            m_content = content;
            m_fonts[FontType.Default] = m_content.Load<SpriteFont>("Font\\Default");
            m_fonts[FontType.MenuTitle] = m_content.Load<SpriteFont>("Font\\MenuTitle");
            m_fonts[FontType.MenuButton] = m_content.Load<SpriteFont>("Font\\MenuButton");
        }

        /// <summary>
        /// Display text on the screen.
        /// </summary>
        /// <param name="type">font type</param>
        /// <param name="text">text</param>
        /// <param name="position">position</param>
        /// <param name="color">color</param>
        public void displayText(FontType type, string text, Vector2 position, Color color)
        {
            if (!m_fonts.ContainsKey(type))
            {
                Logger.Instance.error(this, "Font does not exist");
                return;
            }
            Visu.Instance.displayText(m_fonts[type], text, position, color);
        }

    }
}
